<?php
/**
 * @version $Id: multimarkerpro.php 6 2013-01-22 15:31:03Z szymon $
 * @package Multimarker-Pro
 * @subpackage Multimarker-Pro Component
 * @copyrightCopyright (C) 2013 - 2014 Qubesys Technologies Pvt.Ltd. All rights reserved.
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @author url: http://qubesys.com
 * @author email info@qubesys.com
 *
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

class MultimarkerProTableItem extends JTable
{
	public function __construct(&$db) {
		parent::__construct('#__multimarkerpro', 'id', $db);
	}

	function bind($array, $ignore = '')
	{
		if (isset($array['params']) && is_array($array['params'])) {
			$registry = new JRegistry();
			$registry->loadArray($array['params']);
			$array['params'] = (string)$registry;
		}
		
		if(empty($array['alias'])) {
			$array['alias'] = $array['title'];
		}
		$array['alias'] = JFilterOutput::stringURLSafe($array['alias']);
		if(trim(str_replace('-','',$array['alias'])) == '') {
			$array['alias'] = JFactory::getDate()->format("Y-m-d-H-i-s");
		}
		
		return parent::bind($array, $ignore);
	}
	
}
